﻿/// <reference name="MicrosoftAjax.js"/>
Type.registerNamespace("Books.Publishers");
Books.Publishers.Publisher = function(name, city) {
  Books.Publishers.Publisher.initializeBase(this, [name] );
  this._name = name;
  this._city = city;
}

Books.Publishers.Publisher.prototype = {
  get_name: function() {
    return this._name;
  },
  set_name: function(value) {
    this._name = value;
  },
  get_city: function() {
    return this._city;
  },
  set_city: function(value) {
    this._city = value;
  },

  toString: function() {
    return this._getLocation();
  },

  getLocation: function() {
    return this._name + " w mieście " + this._city; 
  }
}

Books.Publishers.Publisher.registerClass("Books.Publishers.Publisher");

Books.Publishers.NewspaperPublisher = function(name, city, state) {
  this._state = state;

  Books.Publishers.NewspaperPublisher.initializeBase
   (this, [name, city]);
}

Books.Publishers.NewspaperPublisher.prototype = {
  getLocation: function() {
     return 
       this.get_name() + " w mieście " +
       this.get_city() + "(" +
       this._state + ")";

  
//    var baseLocation = Books.Publishers.NewspaperPublisher.callBaseMethod(this, "getLocation");
//    return baseLocation + this._state;
  }
}

Books.Publishers.NewspaperPublisher.registerClass('Books.Publishers.NewspaperPublisher', Books.Publishers.Publisher);
